/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file.filter;

import aljx.java.util.collection.CollectionUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.List;

public class InDir
implements FileFilter {
    private static final boolean PRINT_LOG = false;
    private List<File> dirIncludeList;
    private List<File> dirExcludeList;

    public static InDir excludeDirInstance(File ... dirExcludeArr) {
        return new InDir(null, CollectionUtils.toList(dirExcludeArr));
    }

    public InDir(File ... dirIncludeArr) {
        this(CollectionUtils.toList(dirIncludeArr), null);
    }

    public InDir(List<File> dirIncludeList) {
        this(dirIncludeList, null);
    }

    public InDir(List<File> dirIncludeList, List<File> dirExcludeList) {
        this.dirIncludeList = dirIncludeList;
        this.dirExcludeList = dirExcludeList;
    }

    @Override
    public boolean accept(File fileSource) {
        if (fileSource == null) {
            return false;
        }
        File parentFile = null;
        try {
            parentFile = fileSource.getParentFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parentFile == null) {
            return false;
        }
        if (this.dirExcludeList != null) {
            for (File val : this.dirExcludeList) {
                if (!val.getAbsolutePath().equals(parentFile.getAbsolutePath())) continue;
                return false;
            }
        }
        if (this.dirExcludeList == null) {
            return true;
        }
        for (File val : this.dirExcludeList) {
            if (!val.getAbsolutePath().equals(parentFile.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }
}

