/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file.filter;

import aljx.java.util.collection.CollectionUtils;
import aljx.java.util.filter.Filter;
import java.util.ArrayList;
import java.util.List;

public abstract class FileSourceFilterBase<FileSource>
implements Filter<FileSource> {
    private static final boolean PRINT_LOG = false;
    List<String> fileIncludeList = null;
    List<String> fileExcludeList = null;
    List<String> dirIncludeList = null;
    List<String> dirExcludeList = null;

    public FileSourceFilterBase() {
    }

    public FileSourceFilterBase(String ... fileIncludeArr) {
        this(false, CollectionUtils.toList(fileIncludeArr), null);
    }

    public FileSourceFilterBase(List<String> fileIncludeList) {
        this(false, fileIncludeList, null);
    }

    public FileSourceFilterBase(List<String> fileIncludeList, List<String> fileExcludeList) {
        this(false, fileIncludeList, fileExcludeList);
    }

    public FileSourceFilterBase(boolean acceptDirs, String ... fileIncludeArr) {
        this(acceptDirs, CollectionUtils.toList(fileIncludeArr), null);
    }

    public FileSourceFilterBase(boolean acceptDirs, List<String> fileIncludeList) {
        this(acceptDirs, fileIncludeList, null);
    }

    public FileSourceFilterBase(boolean acceptDirs, List<String> fileIncludeList, List<String> fileExcludeList) {
        this(fileIncludeList, fileExcludeList, acceptDirs ? null : new ArrayList<String>(), null);
    }

    public FileSourceFilterBase(List<String> fileIncludeList, List<String> fileExcludeList, List<String> dirIncludeList, List<String> dirExcludeList) {
        if (fileIncludeList != null) {
            this.fileIncludeList = new ArrayList<String>();
            this.fileIncludeList.addAll(fileIncludeList);
        }
        if (fileExcludeList != null) {
            this.fileExcludeList = new ArrayList<String>();
            this.fileExcludeList.addAll(fileExcludeList);
        }
        if (dirIncludeList != null) {
            this.dirIncludeList = new ArrayList<String>();
            this.dirIncludeList.addAll(dirIncludeList);
        }
        if (dirExcludeList != null) {
            this.dirExcludeList = new ArrayList<String>();
            this.dirExcludeList.addAll(dirExcludeList);
        }
    }

    @Override
    public boolean accept(FileSource fileSource) {
        if (fileSource == null) {
            return false;
        }
        String name = this.getName(fileSource);
        boolean isFile = this.isFile(fileSource);
        boolean isDirectory = this.isDirectory(fileSource);
        if (isFile) {
            if (this.fileExcludeList != null) {
                for (String val : this.fileExcludeList) {
                    if (!this.fileFileNameOperation(val, name)) continue;
                    return false;
                }
            }
            if (this.fileIncludeList == null) {
                return true;
            }
            for (String val : this.fileIncludeList) {
                if (!this.fileFileNameOperation(val, name)) continue;
                return true;
            }
            return false;
        }
        if (isDirectory) {
            if (this.dirExcludeList != null) {
                for (String val : this.dirExcludeList) {
                    if (!this.dirFileNameOperation(val, name)) continue;
                    return false;
                }
            }
            if (this.dirIncludeList == null) {
                return true;
            }
            for (String val : this.dirIncludeList) {
                if (!this.dirFileNameOperation(val, name)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected abstract boolean isDirectory(FileSource var1);

    protected abstract boolean isFile(FileSource var1);

    protected abstract String getName(FileSource var1);

    protected abstract boolean fileFileNameOperation(String var1, String var2);

    protected abstract boolean dirFileNameOperation(String var1, String var2);
}

