/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.debug;

import aljx.java.util.debug.Dumper;
import aljx.java.util.reflection.ReflectionUtils;

public class Logger {
    public static final LogImplementation logger;

    public static void v(String tag, String s) {
        logger.v(tag, s);
    }

    public static void d(String tag, String s) {
        logger.d(tag, s);
    }

    public static void i(String tag, String s) {
        logger.i(tag, s);
    }

    public static void w(String tag, String s) {
        logger.w(tag, s);
    }

    public static void w(String tag, String s, Throwable tr) {
        logger.w(tag, s, tr);
    }

    public static void e(String tag, String s) {
        logger.e(tag, s);
    }

    public static void e(String tag, String s, Throwable tr) {
        logger.e(tag, s, tr);
    }

    static {
        LogImplementation logImplementation = null;
        try {
            logImplementation = (LogImplementation)ReflectionUtils.getInstanceUnsafe("aljx.android.util.debug.AndroidLogger");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logImplementation == null) {
            logImplementation = new DefaultLogger();
            logImplementation.i("Tracer", "Default logger init");
        }
        if (logImplementation == null) {
            throw new IllegalStateException();
        }
        logger = logImplementation;
    }

    private static class DefaultLogger
    implements LogImplementation {
        private DefaultLogger() {
        }

        @Override
        public void v(String tag, String s) {
            System.out.println("" + tag + ", " + s);
        }

        @Override
        public void d(String tag, String s) {
            System.out.println("" + tag + ", " + s);
        }

        @Override
        public void i(String tag, String s) {
            System.out.println("" + tag + ", " + s);
        }

        @Override
        public void w(String tag, String s) {
            System.out.println("" + tag + ", " + s);
        }

        @Override
        public void w(String tag, String s, Throwable tr) {
            System.out.println("" + tag + ", " + s + '\n' + Dumper.dump(tr));
        }

        @Override
        public void e(String tag, String s) {
            System.out.println("" + tag + ", " + s);
        }

        @Override
        public void e(String tag, String s, Throwable tr) {
            System.out.println("" + tag + ", " + s + '\n' + Dumper.dump(tr));
        }
    }

    public static interface LogImplementation {
        public void v(String var1, String var2);

        public void d(String var1, String var2);

        public void i(String var1, String var2);

        public void w(String var1, String var2);

        public void w(String var1, String var2, Throwable var3);

        public void e(String var1, String var2);

        public void e(String var1, String var2, Throwable var3);
    }
}

