/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.debug;

import aljx.java.util.debug.Dumper;
import aljx.java.util.debug.Logger;
import aljx.java.util.file.LogSaveHelper;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FileLogger
implements Logger.LogImplementation {
    private ThreadLocal<SimpleDateFormat> df = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
        }
    };

    public FileLogger(File dir) {
        this(dir, 8L);
    }

    public FileLogger(File dir, long mbSize) {
        LogSaveHelper.setSettings(dir, "log.txt", "old_log.txt", 0x100000L * mbSize);
    }

    public static void resetFile() {
        LogSaveHelper.getLogFileStream(true);
    }

    private void write(String s) {
        try {
            LogSaveHelper.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void v(String tag, String s) {
        String time = this.df.get().format(new Date(System.currentTimeMillis()));
        long tid = Thread.currentThread().getId();
        this.write(String.format("%s    %d/ V %s, %s\n", time, tid, tag, s));
    }

    @Override
    public void d(String tag, String s) {
        String time = this.df.get().format(new Date(System.currentTimeMillis()));
        long tid = Thread.currentThread().getId();
        this.write(String.format("%s    %d/ D %s, %s\n", time, tid, tag, s));
    }

    @Override
    public void i(String tag, String s) {
        String time = this.df.get().format(new Date(System.currentTimeMillis()));
        long tid = Thread.currentThread().getId();
        this.write(String.format("%s    %d/ I %s, %s\n", time, tid, tag, s));
    }

    @Override
    public void w(String tag, String s) {
        String time = this.df.get().format(new Date(System.currentTimeMillis()));
        long tid = Thread.currentThread().getId();
        this.write(String.format("%s    %d/ W %s, %s\n", time, tid, tag, s));
    }

    @Override
    public void w(String tag, String s, Throwable tr) {
        String time = this.df.get().format(new Date(System.currentTimeMillis()));
        long tid = Thread.currentThread().getId();
        this.write(String.format("%s    %d/ W %s, %s \n%s\n", time, tid, tag, s, Dumper.dump(tr)));
    }

    @Override
    public void e(String tag, String s) {
        String time = this.df.get().format(new Date(System.currentTimeMillis()));
        long tid = Thread.currentThread().getId();
        this.write(String.format("%s    %d/ E %s, %s\n", time, tid, tag, s));
    }

    @Override
    public void e(String tag, String s, Throwable tr) {
        String time = this.df.get().format(new Date(System.currentTimeMillis()));
        long tid = Thread.currentThread().getId();
        this.write(String.format("%s    %d/ E %s, %s \n%s\n", time, tid, tag, s, Dumper.dump(tr)));
    }
}

