/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.debug;

import aljx.java.util.debug.DefaultDumpExtension;
import aljx.java.util.reflection.ObjectDumper;
import aljx.java.util.reflection.ReflectionUtils;
import aljx.java.util.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Dumper {
    private static final List<DumpExtension> sExtensionList;

    public static String toString(Object obj, int maxLength) {
        return TextUtils.ellipsize(String.valueOf(obj), maxLength);
    }

    public static String dumpFields(Object obj) {
        return ObjectDumper.dumpFields(obj);
    }

    public static String dump(Object value) {
        return Dumper.dump(value, new ArrayList());
    }

    public static String dump(Object value, ArrayList dumpedObjects) {
        if (value == null) {
            return "null";
        }
        for (Object dumpedItem : dumpedObjects) {
            if (dumpedItem != value) continue;
            return String.format("duplicate %s@%s", value.getClass().getName(), Integer.toHexString(value.hashCode()));
        }
        if (value == dumpedObjects) {
            return String.format("duplicate %s@%s", value.getClass().getName(), Integer.toHexString(value.hashCode()));
        }
        dumpedObjects.add(value);
        String result = null;
        for (DumpExtension extension : sExtensionList) {
            if (!extension.canDump(value)) continue;
            result = extension.dumpImpl(value, dumpedObjects);
            break;
        }
        dumpedObjects.remove(value);
        return result != null ? result : value.toString();
    }

    static {
        ArrayList<DumpExtension> extensions = new ArrayList<DumpExtension>();
        try {
            DumpExtension dumpExtension = (DumpExtension)ReflectionUtils.getInstanceUnsafe("aljx.android.util.debug.AndroidDumpExtension");
            if (dumpExtension != null) {
                extensions.add(dumpExtension);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        extensions.add(new DefaultDumpExtension());
        sExtensionList = Collections.unmodifiableList(extensions);
    }

    public static abstract class DumpExtension {
        protected final String dump(Object value, ArrayList dumpedObjects) {
            return Dumper.dump(value, dumpedObjects);
        }

        public abstract String dumpImpl(Object var1, ArrayList var2);

        public abstract boolean canDump(Object var1);
    }
}

