package aljx.java.util.thread;

import aljx.java.util.debug.Tracer;

public abstract class RecurringThread extends Thread {

    private boolean isRecurring = false;
    private long sleepTime = 0;

    public synchronized void setRecurring(boolean isRecurring) {
        this.isRecurring = isRecurring;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    @Override
    public void run() {
        while (isRecurring) {
            doWork();

            if (sleepTime != 0) {
                try {
                    Thread.sleep(sleepTime);
                } catch (InterruptedException e) {
                    Tracer.e(e);
                }
            }
        }
    }

    public abstract void doWork();

    public static RecurringThread launch(final Runnable runnable, long updateTime) {
        RecurringThread recurringThread = new RecurringThread() {
            @Override
            public void doWork() {
                runnable.run();
            }
        };
        recurringThread.setRecurring(true);
        recurringThread.setSleepTime(updateTime);
        recurringThread.start();
        return recurringThread;
    }
}