package aljx.java.util.text.modify;

import java.util.ArrayList;
import java.util.List;

import aljx.java.util.text.TextUtils;

public class WordWrapModifier implements StringModifier {
    private final int mLineLength;

    public WordWrapModifier(int lineLength) {
        if (lineLength < 1) {
            throw new IllegalArgumentException("Wrong line length = " + lineLength);
        }
        mLineLength = lineLength;
    }

    @Override
    public String modify(String string) {
        if (TextUtils.isEmpty(string)) {
            return string;
        }

        List<String> text = TextUtils.splitLines(string);
        StringBuilder sb = new StringBuilder();
        for (String line : text) {
            if (line.length() > mLineLength) {
                ArrayList<String> splittedLines = TextUtils.wordWrap(line, mLineLength);
                for (String splittedLine : splittedLines) {
                    sb.append(splittedLine).append("\n");
                }
            } else {
                sb.append(line).append("\n");
            }
        }

        return sb.toString();
    }
}