package aljx.java.util.text.modify;

public class ChainModifier implements StringModifier {
    StringModifier[] modifiers;

    public ChainModifier(StringModifier... modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public String modify(String string) {
        for (StringModifier modifier : modifiers) {
            string = modifier.modify(string);
        }
        return string;
    }
}
