package aljx.java.util.text.filter;

import java.util.List;


public class StringStartsWith extends StringFilterBase {

    public StringStartsWith(String arg) {
        super(arg);
    }

    public StringStartsWith(List<String> includeList) {
        super(includeList);
    }

    public StringStartsWith(List<String> includeList, List<String> excludeList) {
        super(includeList, excludeList);
    }

    @Override
    public boolean accept(String string) {
        for (String cur : excludeList) {
            if (string.startsWith(cur)) {
                return false;
            }
        }

        for (String cur : includeList) {
            if (string.startsWith(cur)) {
                return true;
            }
        }

        return false;
    }
}
