package aljx.java.util.text.filter;

import aljx.java.util.collection.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

public abstract class StringFilterBase implements StringFilter {
    final List<String> includeList = new ArrayList<String>();
    final List<String> excludeList = new ArrayList<String>();

    public StringFilterBase(String include) {
        this(CollectionUtils.toList(include), null);
    }

    public StringFilterBase(String... include) {
        this(CollectionUtils.toList(include), null);
    }

    public StringFilterBase(List<String> includeList) {
        this.includeList.addAll(includeList);
    }

    public StringFilterBase(List<String> includeList, List<String> excludeList) {
        if (includeList != null) {
            this.includeList.addAll(includeList);
        }

        if (excludeList != null) {
            this.excludeList.addAll(excludeList);
        }
    }
}
