package aljx.java.util.text.filter;

import java.util.List;

public class StringEqualsIgnoreCase extends StringFilterBase {

    public StringEqualsIgnoreCase(String arg) {
        super(arg);
    }

    public StringEqualsIgnoreCase(List<String> includeList) {
        super(includeList);
    }

    public StringEqualsIgnoreCase(List<String> includeList, List<String> excludeList) {
        super(includeList, excludeList);
    }

    @Override
    public boolean accept(String string) {
        for (String cur : excludeList) {
            if (string.equalsIgnoreCase(cur)) {
                return false;
            }
        }

        for (String cur : includeList) {
            if (string.equals(cur)) {
                return true;
            }
        }

        return false;
    }
}
