package aljx.java.util.text.filter;

import java.util.List;

public class StringEquals extends StringFilterBase {

    public StringEquals(String arg) {
        super(arg);
    }

    public StringEquals(List<String> includeList) {
        super(includeList);
    }

    public StringEquals(List<String> includeList, List<String> excludeList) {
        super(includeList, excludeList);
    }

    @Override
    public boolean accept(String string) {
        for (String cur : excludeList) {
            if (string.equals(cur)) {
                return false;
            }
        }

        for (String cur : includeList) {
            if (string.equals(cur)) {
                return true;
            }
        }

        return false;
    }
}
