package aljx.java.util.text.filter;

import java.util.List;

public class StringEndsWith extends StringFilterBase {
    public StringEndsWith(String arg) {
        super(arg);
    }

    public StringEndsWith(List<String> includeList) {
        super(includeList);
    }

    public StringEndsWith(List<String> includeList, List<String> excludeList) {
        super(includeList, excludeList);
    }

    @Override
    public boolean accept(String string) {
        for (String cur : excludeList) {
            if (string.endsWith(cur)) {
                return false;
            }
        }

        for (String cur : includeList) {
            if (string.endsWith(cur)) {
                return true;
            }
        }

        return false;
    }
}
