package aljx.java.util.text.filter;

import java.util.List;

public class StringContains extends StringFilterBase {

    public StringContains(String arg) {
        super(arg);
    }

    public StringContains(List<String> includeList) {
        super(includeList);
    }

    public StringContains(List<String> includeList, List<String> excludeList) {
        super(includeList, excludeList);
    }

    @Override
    public boolean accept(final String string) {
        for (String cur : excludeList) {
            if (string.contains(cur)) {
                return false;
            }
        }

        for (String cur : includeList) {
            if (string.contains(cur)) {
                return true;
            }
        }

        return false;
    }
}
