package aljx.java.util.text;

public class SqlStringHelper {
    private static final String COMMON_CREATE_QUERY_FORMAT = "CREATE TABLE %1$s (%2$s)";
    private static final String CREATE_IF_NOT_EXISTS_QUERY_FORMAT = "CREATE TABLE IF NOT EXISTS %1$s (%2$s)";

    public static String createTableQuery(boolean ifNotExists, String table, String... args) {
        String query = null;
        final String whitespace = " ";
        final String argSeparator = ", ";
        if (table != null && args != null && args.length >= 2
                && args.length % 2 == 0) {
            StringBuilder fields = new StringBuilder();
            int i = 0;
            while (i < args.length - 2) {
                fields.append(args[i]);
                fields.append(whitespace);
                fields.append(args[++i]);
                fields.append(argSeparator);
                i++;
            }
            fields.append(args[i]);
            fields.append(whitespace);
            fields.append(args[++i]);

            query = String.format(
                    ifNotExists ? CREATE_IF_NOT_EXISTS_QUERY_FORMAT
                            : COMMON_CREATE_QUERY_FORMAT, table, fields
                            .toString());
        }
        return query;
    }

    public static String createTableQuery(String table, String... args) {
        return createTableQuery(false, table, args);
    }

    public static String createReferencesField(String type, String table, String targetField) {
        String result = String.format("%1$s REFERENCES %2$s(%3$s)", type,
                table, targetField);
        return result;
    }

    public static String dropTableQuery(String tableName) {
        String result = String.format("DROP TABLE IF EXISTS %1$s", tableName);
        return result;
    }

    public static String createInStatement(int count) {
        return createInStatement("", count);
    }

    public static String createInStatement(String prefix, int count) {
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(" ").append("IN(?");
        for (int i = 1; i < count; i++) {
            sb.append(", ?");
        }
        sb.append(")");
        final String result = sb.toString();
        return result;
    }
}