package aljx.java.util.stream;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import aljx.java.util.config.DebugLogConfig;
import aljx.java.util.debug.Tracer;
import aljx.java.util.text.filter.StringFilter;

public class StreamReader {

    public static class CloseControl {
        private static final boolean PRINT_LOG = DebugLogConfig.PRINT_FILE_OPERATIONS;

        public static String streamToString(InputStream is, boolean closeInputStream) throws IOException {
            Writer writer = new StringWriter();
            char[] buffer = new char[1024];

            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                int n;
                while ((n = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, n);
                }
            } finally {
                if (closeInputStream) {
                    try {
                        is.close();
                    } catch (Exception e) {

                    }
                }
            }
            return writer.toString();
        }

        public static List<String> streamToStringList(InputStream is, boolean closeInputStream) throws IOException {
            return streamToStringList(is, null, closeInputStream);
        }

        public static List<String> streamToStringList(InputStream is, StringFilter stringFilter,
                                                      boolean closeInputStream) throws IOException {
            ArrayList<String> list = new ArrayList<String>();

            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String line;
                while ((line = reader.readLine()) != null) {
                    if (stringFilter == null || stringFilter.accept(line)) {
                        list.add(line);
                    }
                }
            } finally {
                if (closeInputStream) {
                    try {
                        is.close();
                    } catch (Exception e) {

                    }
                }
            }
            return list;
        }

        public static void transferStream(InputStream is, OutputStream os, boolean closeInputStream) throws IOException {
            try {
                byte[] bytes = streamToBytes(is, closeInputStream);
                os.write(bytes, 0, bytes.length);
            } finally {
                if (closeInputStream) {
                    try {
                        is.close();
                    } catch (Exception e) {

                    }
                }

                try {
                    os.close();
                } catch (Exception e) {

                }
            }
        }

        public static byte[] streamToBytes(InputStream is, boolean closeInputStream) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            int len;

            try {
                while ((len = is.read(buffer)) >= 0) {
                    os.write(buffer, 0, len);
                }
                return os.toByteArray();
            } finally {
                if (closeInputStream) {
                    try {
                        is.close();
                    } catch (Exception e) {

                    }
                }

                try {
                    os.close();
                } catch (Exception e) {

                }
            }
        }

        public static void streamToFile(InputStream is, File targetLocation, boolean closeInputStream) throws IOException {
            if (PRINT_LOG) {
                Tracer.print("targetLocation = " + targetLocation.getAbsolutePath());
            }

            if (targetLocation.exists()) {
                targetLocation.delete();
            }

            if (targetLocation.exists()) {
                throw new IOException("Filed delete " + targetLocation);
            }

            targetLocation.createNewFile();

            OutputStream out = null;

            try {
                out = new FileOutputStream(targetLocation);
                byte[] buffer = new byte[1024];
                int length = 0;

                while ((length = is.read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }

            } finally {
                if (closeInputStream) {
                    try {
                        is.close();
                    } catch (Exception e) {

                    }
                }

                try {
                    out.close();
                } catch (Exception e) {

                }
            }
        }
    }

    public static String streamToString(InputStream is) throws IOException {
        return CloseControl.streamToString(is, true);
    }

    public static List<String> streamToStringList(InputStream is) throws IOException {
        return CloseControl.streamToStringList(is, null, true);
    }

    public static List<String> streamToStringList(InputStream is, StringFilter stringFilter) throws IOException {
        return CloseControl.streamToStringList(is, stringFilter, true);
    }

    public static void transferStream(InputStream is, OutputStream os) throws IOException {
        CloseControl.transferStream(is, os, true);
    }

    public static byte[] streamToBytes(InputStream is) throws IOException {
        return CloseControl.streamToBytes(is, true);
    }

    public static void streamToFile(InputStream is, File targetLocation) throws IOException {
        CloseControl.streamToFile(is, targetLocation, true);
    }
}