package aljx.java.util.state;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class ConcurrentCache {
    private static final ConcurrentHashMap<Object, Object> MAP = new ConcurrentHashMap<Object, Object>();
    private static final AtomicReference<Object> NULL_KEY = new AtomicReference<Object>();

    public <T> T get(Object key) {
        return key == null ? (T) NULL_KEY.get() : (T) MAP.get(key);
    }

    public <T> T get(Object key, Class<T> tClass) {
        return key == null ? (T) NULL_KEY.get() : (T) MAP.get(key);
    }

    public <T> T put(Object key, T value) {
        return key == null ?
                (T) NULL_KEY.getAndSet(value) :
                (
                        value == null ?
                                (T) MAP.remove(key) :
                                (T) MAP.put(key, value)
                );
    }

    public <T> T remove(Object key) {
        return key == null ? (T) NULL_KEY.getAndSet(null) : (T) MAP.remove(key);
    }

    public void clear() {
        NULL_KEY.set(null);
        MAP.clear();
    }

    public <T> boolean compare(Object key, T value) {
        Object storedValue = get(key);
        return storedValue == null ? value == null : storedValue.equals(value);
    }
}
