package aljx.java.util.image;

/**
 * @author Alex Andriichenko
 */
public class ARGBPixelHelper {

    public static boolean isTransparent(int pixel) {
        return getAlpha(pixel) == 0;
    }

    public static boolean isTranslucent(int pixel) {
        return getAlpha(pixel) > 0;
    }

    public static boolean isFullOpacity(int pixel) {
        return getAlpha(pixel) == 255;
    }

    public static String getPixelInfo(int pixel, int x, int y) {
        int alpha = getAlpha(pixel);
        int red = getRed(pixel);
        int green = getGreen(pixel);
        int blue = getBlue(pixel);
        return String.format("(%d,%d) argb: %d, %d, %d, %d", x, y, alpha, red, green, blue);
    }

    private static int getBlue(int pixel) {
        return (pixel) & 0xff;
    }

    private static int getGreen(int pixel) {
        return (pixel >> 8) & 0xff;
    }

    private static int getRed(int pixel) {
        return (pixel >> 16) & 0xff;
    }

    private static int getAlpha(int pixel) {
        return (pixel >> 24) & 0xff;
    }
}
