package aljx.java.util.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;

import aljx.java.util.file.zip.filter.ZipEntryFilter;
import aljx.java.util.text.filter.StringFilter;

/**
 * @author Alex Andriichenko
 */
class FilterWrapper {

    public static <FilterType, CheckingArgType> Filter<CheckingArgType> wrap(final FilterType filter) {

        if (filter == null) {
            throw new IllegalArgumentException("filter = " + filter);
        }

        return new Filter<CheckingArgType>() {

            @Override
            public boolean accept(CheckingArgType checkingArgType) {
                if (filter instanceof StringFilter) {
                    return ((StringFilter) filter).accept((String) checkingArgType);
                }

                if (filter instanceof FileFilter) {
                    return ((FileFilter) filter).accept((File) checkingArgType);
                }

                if (filter instanceof ZipEntryFilter) {
                    return ((ZipEntryFilter) filter).accept((ZipEntry) checkingArgType);
                }

                throw new IllegalArgumentException("Unknown filter = " + filter);
            }
        };
    }

    public static <FilterType> List<Filter> wrap(FilterType... filterArr) {
        return wrap(Arrays.asList(filterArr));
    }

    public static <FilterType> List<Filter> wrap(List<FilterType> stringFilterList) {

        List<Filter> list = new ArrayList<Filter>();
        for (FilterType item : stringFilterList) {
            list.add(wrap(item));
        }
        return list;
    }
}
