package aljx.java.util.filter;

import java.util.ArrayList;

/**
 * @author Alex Andriichenko
 */
public class FilterSet<CheckingArgType> implements Filter<CheckingArgType> {
    private boolean checkAll = false;
    private ArrayList<Filter> filterSet = new ArrayList<Filter>();

    public FilterSet() {

    }

    public <FilterType> FilterSet(FilterType... filterArr) {
        this(false, filterArr);
    }

    public <FilterType> FilterSet(boolean checkAll, FilterType... filterArr) {
        this.checkAll = checkAll;
        if (filterArr != null) {
            this.filterSet = new ArrayList<Filter>();
            this.filterSet.addAll(FilterWrapper.wrap(filterArr));
        } else {
            this.filterSet = null;
        }
    }

    @Override
    public boolean accept(CheckingArgType arg) {
        if (arg == null) {
            return false;
        }

        if (filterSet == null) {
            return true;
        }

        if (filterSet.size() == 0) {
            return false;
        }

        if (checkAll) {
            for (Filter<CheckingArgType> filter : filterSet) {
                if (!filter.accept(arg)) {
                    return false;
                }
            }
            return true;
        } else {
            for (Filter<CheckingArgType> filter : filterSet) {
                if (filter.accept(arg)) {
                    return true;
                }
            }
        }

        return false;
    }
}
