package aljx.java.util.file.zip.filter;

import java.util.List;

import aljx.java.util.collection.CollectionUtils;

/**
 * @author Alex Andriichenko
 */
public class ZippedFileEntryFilter extends ZipEntryFilterBase {

    public static ZippedFileEntryFilter excludeFileInstance(String... fileExcludeArr) {
        return new ZippedFileEntryFilter(null, CollectionUtils.toList(fileExcludeArr), null, null);
    }

    public static ZippedFileEntryFilter excludeDirInstance(String... dirExcludeArr) {
        return new ZippedFileEntryFilter(null, null, null, CollectionUtils.toList(dirExcludeArr));
    }

    public ZippedFileEntryFilter() {

    }

    public ZippedFileEntryFilter(String... fileIncludeArr) {
        super(fileIncludeArr);
    }

    public ZippedFileEntryFilter(List<String> fileIncludeList) {
        super(fileIncludeList);
    }

    public ZippedFileEntryFilter(List<String> fileIncludeList, List<String> fileExcludeList) {
        super(fileIncludeList, fileExcludeList);
    }

    public ZippedFileEntryFilter(boolean acceptDirs, String... fileIncludeArr) {
        super(acceptDirs, fileIncludeArr);
    }

    public ZippedFileEntryFilter(boolean acceptDirs, List<String> fileIncludeList) {
        super(acceptDirs, fileIncludeList);
    }

    public ZippedFileEntryFilter(boolean acceptDirs, List<String> fileIncludeList, List<String> fileExcludeList) {
        super(acceptDirs, fileIncludeList, fileExcludeList);
    }

    public ZippedFileEntryFilter(List<String> fileIncludeList, List<String> fileExcludeList, List<String> dirIncludeList, List<String> dirExcludeList) {
        super(fileIncludeList, fileExcludeList, dirIncludeList, dirExcludeList);
    }

    @Override
    protected boolean fileFileNameOperation(String ruleVal, String filename) {
        return ruleVal.equals(filename);
    }

    @Override
    protected boolean dirFileNameOperation(String ruleVal, String filename) {
        return ruleVal.equals(filename);
    }
}
