package aljx.java.util.file.zip.filter;

import java.util.List;
import java.util.zip.ZipEntry;

import aljx.java.util.collection.CollectionUtils;

/**
 * @author Alex Andriichenko
 */
public class RootZippedFileEntryFilter extends ZipEntryFilterBase {

    public static RootZippedFileEntryFilter excludeFileInstance(String... fileExcludeArr) {
        return new RootZippedFileEntryFilter(null, CollectionUtils.toList(fileExcludeArr), null, null);
    }

    public static RootZippedFileEntryFilter excludeDirInstance(String... dirExcludeArr) {
        return new RootZippedFileEntryFilter(null, null, null, CollectionUtils.toList(dirExcludeArr));
    }

    public RootZippedFileEntryFilter() {

    }

    public RootZippedFileEntryFilter(String... fileIncludeArr) {
        super(fileIncludeArr);
    }

    public RootZippedFileEntryFilter(List<String> fileIncludeList) {
        super(fileIncludeList);
    }

    public RootZippedFileEntryFilter(List<String> fileIncludeList, List<String> fileExcludeList) {
        super(fileIncludeList, fileExcludeList);
    }

    public RootZippedFileEntryFilter(boolean acceptDirs, String... fileIncludeArr) {
        super(acceptDirs, fileIncludeArr);
    }

    public RootZippedFileEntryFilter(boolean acceptDirs, List<String> fileIncludeList) {
        super(acceptDirs, fileIncludeList);
    }

    public RootZippedFileEntryFilter(boolean acceptDirs, List<String> fileIncludeList, List<String> fileExcludeList) {
        super(acceptDirs, fileIncludeList, fileExcludeList);
    }

    public RootZippedFileEntryFilter(List<String> fileIncludeList, List<String> fileExcludeList, List<String> dirIncludeList, List<String> dirExcludeList) {
        super(fileIncludeList, fileExcludeList, dirIncludeList, dirExcludeList);
    }

    @Override
    protected boolean fileFileNameOperation(String ruleVal, String filename) {
        return ruleVal.equals(filename);
    }

    @Override
    protected boolean dirFileNameOperation(String ruleVal, String filename) {
        return ruleVal.equals(filename);
    }

    @Override
    public boolean accept(ZipEntry zipEntry) {
        return super.accept(zipEntry) && zipEntry.getName().equals(getName(zipEntry));
    }
}
