package aljx.java.util.file.zip;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;

import aljx.java.util.config.DebugLogConfig;
import aljx.java.util.debug.Dumper;
import aljx.java.util.debug.Tracer;
import aljx.java.util.text.TextUtils;

/**
 * @author Alex Andriichenko
 */
public class ZipHelper {

    private static final boolean PRINT_LOG = DebugLogConfig.PRINT_FILE_OPERATIONS;

    public static String getName(ZipEntry zipEntry) {
        String name = zipEntry.getName();
        int lastIndexOfSeparator = name.lastIndexOf("\\");
        if (lastIndexOfSeparator == -1) {
            lastIndexOfSeparator = name.lastIndexOf("/");
        }

        if (lastIndexOfSeparator > -1 && lastIndexOfSeparator + 1 < name.length()) {
            name = name.substring(lastIndexOfSeparator + 1);
        }

        return name;
    }

    public static boolean isDirectory(ZipEntry zipEntry) {
        String name = zipEntry.getName();
        return name.endsWith("\\") || name.endsWith("/");
    }

    public static boolean isFile(ZipEntry zipEntry) {
        String name = zipEntry.getName();
        return !TextUtils.isEmpty(name) && !isDirectory(zipEntry);
    }

    public static String getDirectory(ZipEntry zipEntry) {
        String name = zipEntry.getName();
        int lastIndexOfSeparator = name.lastIndexOf("\\");
        if (lastIndexOfSeparator == -1) {
            lastIndexOfSeparator = name.lastIndexOf("/");
        }

        String dir = null;
        if (lastIndexOfSeparator > -1) {
            dir = name.substring(0, lastIndexOfSeparator);
        }

        return dir;
    }

    public static void fixEntryList(ArrayList<ZipEntryFile> zipEntryFileList) {
        if (PRINT_LOG) {
            Tracer.print(Dumper.dump(zipEntryFileList));
        }

        HashMap<String, ZipEntryFile> zipArchiveNames = new HashMap<String, ZipEntryFile>();
        for (ZipEntryFile zipEntryFile : zipEntryFileList) {
            zipEntryFile.fixName(zipArchiveNames);
            zipArchiveNames.put(zipEntryFile.getEntryName(), zipEntryFile);
        }
        zipEntryFileList.clear();
        zipEntryFileList.addAll(zipArchiveNames.values());

        if (PRINT_LOG) {
            Tracer.print(Dumper.dump(zipEntryFileList));
        }
    }


}
