package aljx.java.util.file.zip;

import java.io.File;
import java.util.HashMap;

import aljx.java.util.config.DebugLogConfig;
import aljx.java.util.debug.Dumper;
import aljx.java.util.debug.Tracer;

public final class ZipEntryFile {
    private static final boolean PRINT_LOG = DebugLogConfig.PRINT_FILE_OPERATIONS;
    private static final String DUP_SUFFIX = "_dup";
    private static final int DUP_SUFFIX_LENGTH = DUP_SUFFIX.length();

    public final File file;
    private String entryName;

    public ZipEntryFile(File file, String entryName) {
        this.file = file;
        this.entryName = entryName;
    }

    public String getEntryName() {
        return entryName;
    }

    public void fixName(HashMap<String, ZipEntryFile> zipArchiveNames) {

        if (PRINT_LOG) {
            Tracer.print(Dumper.dump(zipArchiveNames) + " entryName = " + entryName);
        }

        String name = entryName;
        if (zipArchiveNames.containsKey(name) &&
                !(file.isDirectory() && zipArchiveNames.get(name).file.isDirectory())) {

            int lastIndexOf = name.lastIndexOf(DUP_SUFFIX);
            if (lastIndexOf > -1) {
                try {
                    Integer num = Integer.valueOf(name.substring(lastIndexOf + DUP_SUFFIX_LENGTH));
                    if (PRINT_LOG) {
                        Tracer.print("num = " + num);
                    }
                    name = name.substring(0, lastIndexOf + DUP_SUFFIX_LENGTH);
                } catch (Exception e) {

                }
            }

            if (!name.endsWith(DUP_SUFFIX)) {
                name += DUP_SUFFIX;
            }

            int i = 1;
            while (zipArchiveNames.containsKey(name + i)) {
                i++;
            }
            name += i;
        }

        entryName = name;

        if (PRINT_LOG) {
            Tracer.print(Dumper.dump(zipArchiveNames) + " entryName = " + entryName);
        }
    }
}