package aljx.java.util.file.filter;

import java.io.File;
import java.io.FileFilter;

import aljx.java.util.config.DebugLogConfig;
import aljx.java.util.debug.Tracer;

/**
 * @author Alex Andriichenko
 */
public class NotFileNotDirectory implements FileFilter {

    @Override
    public boolean accept(File pathname) {
        final boolean result = pathname != null && !pathname.isFile() && !pathname.isDirectory();

        if (DebugLogConfig.PRINT_FILE_OPERATIONS) {
            Tracer.print("result = " + result);
        }
        return result;
    }
}
