package aljx.java.util.file.filter;

import java.io.File;
import java.io.FileFilter;

import aljx.java.util.config.DebugLogConfig;
import aljx.java.util.debug.Tracer;

/**
 * @author Alex Andriichenko
 */
public class IsEmptyDirectory implements FileFilter {

    @Override
    public boolean accept(File pathname) {
        boolean result = pathname != null && pathname.isDirectory();

        if (result) {
            String[] subFiles = pathname.list();
            result = subFiles != null && subFiles.length == 0;
        }

        if (DebugLogConfig.PRINT_FILE_OPERATIONS) {
            Tracer.print("result = " + result);
        }
        return result;
    }
}
