package aljx.java.util.file.filter;

import java.io.File;
import java.io.FileFilter;

import aljx.java.util.config.DebugLogConfig;
import aljx.java.util.debug.Tracer;

public class IsDirectory implements FileFilter {

    @Override
    public boolean accept(File pathname) {
        final boolean result = pathname != null && pathname.isDirectory();

        if (DebugLogConfig.PRINT_FILE_OPERATIONS) {
            Tracer.print("result = " + result);
        }

        return result;
    }
}