package aljx.java.util.file.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.List;

import aljx.java.util.collection.CollectionUtils;
import aljx.java.util.config.DebugLogConfig;
import aljx.java.util.debug.Dumper;
import aljx.java.util.debug.Tracer;

public class InDir implements FileFilter {
    private static final boolean PRINT_LOG = DebugLogConfig.PRINT_FILE_FILTER_LOGIC;
    private List<File> dirIncludeList;
    private List<File> dirExcludeList;

    public static InDir excludeDirInstance(File... dirExcludeArr) {
        return new InDir(null, CollectionUtils.toList(dirExcludeArr));
    }

    public InDir(File... dirIncludeArr) {
        this(CollectionUtils.toList(dirIncludeArr), null);
    }

    public InDir(List<File> dirIncludeList) {
        this(dirIncludeList, null);
    }

    public InDir(List<File> dirIncludeList, List<File> dirExcludeList) {
        this.dirIncludeList = dirIncludeList;
        this.dirExcludeList = dirExcludeList;
    }

    @Override
    public boolean accept(File fileSource) {
        if (PRINT_LOG) {
            Tracer.print("===========");
            Tracer.print("fileSource = " + fileSource);
            Tracer.print("filter rules:"
                    + "\ndir include list = " + Dumper.dump(dirIncludeList)
                    + "\ndir exclude list = " + Dumper.dump(dirExcludeList));

        }

        if (fileSource == null) {
            if (PRINT_LOG) {
                Tracer.print("fileSource source == null return false");
            }

            return false;
        }

        File parentFile = null;
        try {
            parentFile = fileSource.getParentFile();
        } catch (Exception e) {

        }

        if (parentFile == null) {
            return false;
        }

        if (dirExcludeList != null) {
            for (File val : dirExcludeList) {
                if (PRINT_LOG) {
                    Tracer.print("check exclude fileSource. cur = " + val + " parentFile = " + parentFile);
                }

                if (val.getAbsolutePath().equals(parentFile.getAbsolutePath())) {
                    if (PRINT_LOG) {
                        Tracer.print("in exclude list. parentFile = " + parentFile + " return false");
                    }
                    return false;
                }
            }
        }

        if (dirExcludeList == null) {
            if (PRINT_LOG) {
                Tracer.print("include. return true");
            }
            return true;
        }

        for (File val : dirExcludeList) {
            if (PRINT_LOG) {
                Tracer.print("check include fileSource. cur = " + val + " parentFile = " + parentFile);
            }
            if (val.getAbsolutePath().equals(parentFile.getAbsolutePath())) {
                if (PRINT_LOG) {
                    Tracer.print("in include list. parentFile = " + parentFile + " return true");
                }
                return true;
            }
        }

        if (PRINT_LOG) {
            Tracer.print("not in include file list. return false");
        }

        return false;
    }
}