package aljx.java.util.file.filter;


import java.util.List;

import aljx.java.util.collection.CollectionUtils;

public class FileType extends FileFilterBase {

    public static FileType excludeFileInstance(String... fileExcludeArr) {
        return new FileType(null, CollectionUtils.toList(fileExcludeArr), null, null);
    }

    public static FileType excludeDirInstance(String... dirExcludeArr) {
        return new FileType(null, null, null, CollectionUtils.toList(dirExcludeArr));
    }

    public static FileType dirInstance(String... dirIncludeArr) {
        return new FileType(null, null, CollectionUtils.toList(dirIncludeArr), null);
    }

    public static FileType dirInstance(List<String> dirIncludeList, List<String> dirExcludeList) {
        return new FileType(null, null, dirIncludeList, dirExcludeList);
    }

    public FileType() {

    }

    public FileType(String... fileIncludeArr) {
        super(fileIncludeArr);
    }

    public FileType(List<String> fileIncludeList) {
        super(fileIncludeList);
    }

    public FileType(List<String> fileIncludeList, List<String> fileExcludeList) {
        super(fileIncludeList, fileExcludeList);
    }

    public FileType(boolean acceptDirs, String... fileIncludeArr) {
        super(acceptDirs, fileIncludeArr);
    }

    public FileType(boolean acceptDirs, List<String> fileIncludeList) {
        super(acceptDirs, fileIncludeList);
    }

    public FileType(boolean acceptDirs, List<String> fileIncludeList, List<String> fileExcludeList) {
        super(acceptDirs, fileIncludeList, fileExcludeList);
    }

    public FileType(List<String> fileIncludeList, List<String> fileExcludeList, List<String> dirIncludeList, List<String> dirExcludeList) {
        super(fileIncludeList, fileExcludeList, dirIncludeList, dirExcludeList);
    }

    @Override
    protected boolean fileFileNameOperation(String val, String filename) {
        return filename.endsWith(val);
    }

    @Override
    protected boolean dirFileNameOperation(String val, String filename) {
        return val.equals(filename);
    }
}