package aljx.java.util.file.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

/**
 * @author Alex Andriichenko
 */
public class FileSetFilter implements FileFilter {
    ArrayList<String> includeList;
    ArrayList<String> excludeList;

    public static FileSetFilter excludeInstance(File... exclude) {
        return new FileSetFilter(null, exclude);
    }

    public FileSetFilter() {

    }

    public FileSetFilter(File... include) {
        this(include, null);
    }

    public FileSetFilter(File[] include, File[] exclude) {
        if (include != null) {
            this.includeList = new ArrayList<String>();
            for (File f : include) {
                includeList.add(f.getAbsolutePath());
            }
        }

        if (exclude != null) {
            this.excludeList = new ArrayList<String>();
            for (File f : exclude) {
                excludeList.add(f.getAbsolutePath());
            }
        }
    }

    public FileSetFilter(ArrayList<String> includeList, ArrayList<String> excludeList) {
        if (includeList != null) {
            this.includeList = new ArrayList<String>();
            this.includeList.addAll(includeList);
        }

        if (excludeList != null) {
            this.excludeList = new ArrayList<String>();
            this.excludeList.addAll(excludeList);
        }
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname == null) {
            return false;
        }

        String absolutePath = pathname.getAbsolutePath();
        if (excludeList != null && excludeList.contains(absolutePath)) {
            return false;
        }

        if (includeList == null) {
            return true;
        }

        if (includeList.contains(absolutePath)) {
            return true;
        }

        return false;
    }
}
