package aljx.java.util.file.filter;

import java.util.List;

import aljx.java.util.collection.CollectionUtils;

public class FileName extends FileFilterBase {

    public static FileName excludeFileInstance(String... fileExcludeArr) {
        return new FileName(null, CollectionUtils.toList(fileExcludeArr), null, null);
    }

    public static FileName excludeDirInstance(String... exclude) {
        return new FileName(null, null, null, CollectionUtils.toList(exclude));
    }

    public static FileType dirInstance(String... dirIncludeArr) {
        return new FileType(null, null, CollectionUtils.toList(dirIncludeArr), null);
    }

    public static FileType dirInstance(List<String> dirIncludeList, List<String> dirExcludeList) {
        return new FileType(null, null, dirIncludeList, dirExcludeList);
    }

    public FileName() {

    }

    public FileName(String... fileIncludeArr) {
        super(fileIncludeArr);
    }

    public FileName(List<String> fileIncludeList) {
        super(fileIncludeList);
    }

    public FileName(List<String> fileIncludeList, List<String> fileExcludeList) {
        super(fileIncludeList, fileExcludeList);
    }

    public FileName(boolean acceptDirs, String... fileIncludeArr) {
        super(acceptDirs, fileIncludeArr);
    }

    public FileName(boolean acceptDirs, List<String> fileIncludeList) {
        super(acceptDirs, fileIncludeList);
    }

    public FileName(boolean acceptDirs, List<String> fileIncludeList, List<String> fileExcludeList) {
        super(acceptDirs, fileIncludeList, fileExcludeList);
    }

    public FileName(List<String> fileIncludeList, List<String> fileExcludeList, List<String> dirIncludeList, List<String> dirExcludeList) {
        super(fileIncludeList, fileExcludeList, dirIncludeList, dirExcludeList);
    }

    @Override
    protected boolean fileFileNameOperation(String val, String filename) {
        return val.equals(filename);
    }

    @Override
    protected boolean dirFileNameOperation(String val, String filename) {
        return val.equals(filename);
    }
}
