package aljx.java.util.file.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.List;

public abstract class FileFilterBase extends FileSourceFilterBase<File> implements FileFilter {
    public FileFilterBase() {

    }

    public FileFilterBase(String... fileIncludeArr) {
        super(fileIncludeArr);
    }

    public FileFilterBase(List<String> fileIncludeList) {
        super(fileIncludeList);
    }

    public FileFilterBase(List<String> fileIncludeList, List<String> fileExcludeList) {
        super(fileIncludeList, fileExcludeList);
    }

    public FileFilterBase(boolean acceptDirs, String... fileIncludeArr) {
        super(acceptDirs, fileIncludeArr);
    }

    public FileFilterBase(boolean acceptDirs, List<String> fileIncludeList) {
        super(acceptDirs, fileIncludeList);
    }

    public FileFilterBase(boolean acceptDirs, List<String> fileIncludeList, List<String> fileExcludeList) {
        super(acceptDirs, fileIncludeList, fileExcludeList);
    }

    public FileFilterBase(List<String> fileIncludeList, List<String> fileExcludeList, List<String> dirIncludeList, List<String> dirExcludeList) {
        super(fileIncludeList, fileExcludeList, dirIncludeList, dirExcludeList);
    }

    @Override
    protected boolean isDirectory(File file) {
        return file.isDirectory();
    }

    @Override
    protected boolean isFile(File file) {
        return file.isFile();
    }

    @Override
    protected String getName(File file) {
        return file.getName();
    }
}