package aljx.java.util.file;

import java.io.IOException;
import java.io.RandomAccessFile;

import aljx.java.util.debug.Tracer;

public class WavFile {
    public static final int TEN_MB_IN_BYTES = 10 * 1024 * 1024;
    public static final short FORMAT_PCM = 1;
    public static final short FORMAT_ALAW = 6;
    public static final short FORMAT_ULAW = 7;
    private RandomAccessFile mFile = null;

    public WavFile(String filename, short channelsNumber, int sampleRate,
                   short bitsPerSample) throws IOException {
        this(filename, FORMAT_PCM, channelsNumber, sampleRate, bitsPerSample);
    }

    public WavFile(String filename, short wavFormat, short channelsNumber,
                   int sampleRate, short bitsPerSample) throws IOException {
        try {
            mFile = new RandomAccessFile(filename, "rw");
            createHeader(wavFormat, channelsNumber, sampleRate, bitsPerSample);
        } catch (IOException e) {
            if (mFile != null) {
                try {
                    mFile.close();
                } catch (IOException e1) {

                }
                mFile = null;
            }
            throw e;
        }
    }

    public WavFile(String filename) throws IOException {
        try {
            mFile = new RandomAccessFile(filename, "rw");
            mFile.seek(44);
        } catch (IOException e) {
            if (mFile != null) {
                try {
                    mFile.close();
                } catch (IOException e1) {

                }
                mFile = null;
            }
            throw e;
        }
    }

    public void close(int savedDataSize) throws IOException {
        try {
            mFile.seek(4);
            writeInt(mFile, savedDataSize + 36);
            mFile.seek(40);
            writeInt(mFile, savedDataSize);
        } catch (IOException e) {
            Tracer.e(e);
        }
        mFile.close();
    }

    public void close() throws IOException {
        try {
            final long savedDataSize = mFile.getChannel().size() - 44;
            mFile.seek(4);
            writeInt(mFile, (int) savedDataSize + 36);
            mFile.seek(40);
            writeInt(mFile, (int) savedDataSize);
        } catch (IOException e) {
            Tracer.e(e);
        }
        mFile.close();
    }

    public void write(byte[] buffer, int byteOffset, int byteCount)
            throws IOException {
        mFile.write(buffer, byteOffset, byteCount);
    }

    public int read(byte[] buffer, int byteOffset, int byteCount)
            throws IOException {
        return mFile.read(buffer, byteOffset, byteCount);
    }

    private void createHeader(short wavFormat, short channelsNumber,
                              int sampleRate, short bitsPerSample) throws IOException {
        mFile.setLength(0); // Truncate the file if it already exists.
        mFile.writeBytes("RIFF");
        writeInt(mFile, 0);
        mFile.writeBytes("WAVE");

		/* fmt chunk */
        mFile.writeBytes("fmt ");
        writeInt(mFile, 16);
        writeShort(mFile, wavFormat);
        writeShort(mFile, channelsNumber);
        writeInt(mFile, sampleRate);
        writeInt(mFile, channelsNumber * sampleRate * bitsPerSample / 8);
        writeShort(mFile, (short) (channelsNumber * bitsPerSample / 8));
        writeShort(mFile, bitsPerSample);

		/* data chunk */
        mFile.writeBytes("data");
        writeInt(mFile, 0);
    }

    private void writeInt(RandomAccessFile raf, int val) throws IOException {
        raf.write(val >> 0);
        raf.write(val >> 8);
        raf.write(val >> 16);
        raf.write(val >> 24);
    }

    private void writeShort(RandomAccessFile raf, short val) throws IOException {
        raf.write(val >> 0);
        raf.write(val >> 8);
    }

}
