package aljx.java.util.file;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;

import aljx.java.util.config.DebugLogConfig;
import aljx.java.util.debug.Tracer;

public class FileSearcher {
    private static final boolean PRINT_LOG = DebugLogConfig.PRINT_FILE_OPERATIONS;
    private final ArrayList<File> mFileList = new ArrayList<File>();

    public void clear() {
        mFileList.clear();
    }

    public static ArrayList<File> find(File file, FileFilter findFilter, FileFilter addFilter) {
        FileSearcher fileSearcher = new FileSearcher();
        fileSearcher.findFiles(file, findFilter, addFilter);
        return fileSearcher.getFileList();
    }

    public void findFiles(File file, FileFilter findFilter, FileFilter addFilter) {

        if (addFilter == null || addFilter.accept(file)) {
            mFileList.add(file);
        }

        if (file.isDirectory()) {
            File[] files = file.listFiles(findFilter);
            if (files != null) {
                for (File subFile : files) {
                    findFiles(subFile, findFilter, addFilter);
                }
            }
        }
    }

    public ArrayList<File> getFileList() {
        ArrayList<File> list = new ArrayList<File>();
        list.addAll(mFileList);
        return list;
    }

    public ArrayList<String> getAbsoluteFileNameList() {
        ArrayList<String> list = new ArrayList<String>();
        for (File f : mFileList) {
            list.add(f.getAbsolutePath());
        }
        return list;
    }

    public ArrayList<String> getFileNameList() {
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        for (File f : mFileList) {
            set.add(f.getName());
        }
        list.addAll(set);
        return list;
    }

    public static ArrayList<String> getDependedFileNameList(ArrayList<File> fileList, File dir) {
        ArrayList<String> list = new ArrayList<String>();
        String dirPath = dir.getAbsolutePath();

        if (PRINT_LOG) {
            Tracer.print("dirPath = " + dirPath);
        }

        for (File f : fileList) {
            String filePath = f.getAbsolutePath();

            if (PRINT_LOG) {
                Tracer.print("filePath = " + filePath);
            }

            if (filePath.startsWith(dirPath) && filePath.length() > dirPath.length()) {
                filePath = filePath.substring(dirPath.length() + 1, filePath.length());
            } else {
                throw new IllegalArgumentException("Wrong dir = " + dirPath + " for file = " + filePath);
            }

            list.add(filePath);
        }
        return list;
    }
}
