package aljx.java.util.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

/**
 * @author Alex Andriichenko
 */
public class FileInfoSearcher {

    private final ArrayList<FileInfo> mFileList = new ArrayList<FileInfo>();
    private static int mFileChecked;

    public static ArrayList<File> getAllInnerFiles(File file) {
        return getAllInnerFiles(file, null, null);
    }

    public static ArrayList<File> getAllInnerFiles(File file, FileFilter addFilter, FileFilter listFilter) {
        ArrayList<File> fileList = new ArrayList<File>();
        mFileChecked = 0;
        getAllInnerFiles(file, fileList, addFilter, listFilter);
        mFileChecked = 0;
        return fileList;
    }

    private static void printGetFileProgress() {
        mFileChecked++;
        if (mFileChecked % 1000 == 0) {
            System.out.print('.');
        }

        if (mFileChecked % 100000 == 0) {
            System.out.println();
        }
    }

    private static void getAllInnerFiles(File file, ArrayList<File> fileList, FileFilter addFilter, FileFilter listFilter) {
        if (addFilter == null || addFilter.accept(file)) {
            fileList.add(file);
        }

        printGetFileProgress();

        if (file.isDirectory()) {
            File[] fileArr = listFilter == null ? file.listFiles() : file.listFiles(listFilter);
            if (fileArr == null) {
                System.out.println("\n null subfiles arr for " + file.getAbsolutePath());
            } else {
                for (File childFile : fileArr) {
                    getAllInnerFiles(childFile, fileList, addFilter, listFilter);
                }
            }
        }
    }

    public void clear() {
        mFileList.clear();
    }

    public int size() {
        return mFileList.size();
    }

    public void findFiles(File file) {

        mFileList.add(new FileInfo(file));

        if (mFileList.size() % 1000 == 0) {
            System.out.print('.');
        }

        if (mFileList.size() % 100000 == 0) {
            System.out.println();
        }

        if (file.isDirectory()) {
            File[] fileArr = file.listFiles();
            if (fileArr == null) {
                System.out.println("\n null subfiles arr for " + file.getAbsolutePath());
            } else {
                for (File childFile : fileArr) {
                    findFiles(childFile);
                }
            }
        }
    }

    public void saveToFile(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }

        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        long l = 0;
        for (FileInfo fi : mFileList) {
            bufferedWriter.write(fi.getFileInfoString());
            l++;

            if (l % 1000 == 0) {
                System.out.print('.');
            }

            if (l % 100000 == 0) {
                System.out.println();
            }
        }
        bufferedWriter.close();
        System.out.println("\n " + l + " strings saved");
    }


}
