package aljx.java.util.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;

import aljx.java.util.date.DateUtils;

public final class FileInfo {

    private final File file;
    public final long fileSize;
    public final boolean isDirectory;
    public final String path;
    public final String name;
    public final long lastModified;

    public FileInfo(File file) {
        this.file = file;
        isDirectory = file.isDirectory();
        fileSize = file.length();
        path = file.getAbsolutePath();
        name = file.getName();
        lastModified = file.lastModified();
    }

    public String getFileInfoString() {
        final StringBuilder sb = new StringBuilder();
        sb.append(isDirectory ? "[D] " : "[F] ").append("\t\t\t").append(fileSize).append("\t\t\t").append("lastModified ").append(DateUtils.gatDateTime(lastModified)).append("\t\t\t").append(name).append("\t\t\t").append(path).append('\n');
        return sb.toString();
    }

    public String getFileInfoString(FileInfo prevFi) {
        final StringBuilder sb = new StringBuilder();
        sb.append(isDirectory ? "[D] " : "[F] ").append("\t\t\t").append(fileSize);
        sb.append("\t\t\t").append("lastModified ").append(DateUtils.gatDateTime(lastModified));
        if (prevFi != null && isDirectory == prevFi.isDirectory && fileSize == prevFi.fileSize) {
            sb.append("!s");
        }
        if (prevFi != null && isDirectory == prevFi.isDirectory && fileSize == prevFi.fileSize && lastModified == prevFi.lastModified) {
            sb.append("!a");
        }
        if (prevFi != null && isDirectory == prevFi.isDirectory && name.equals(prevFi.name)) {
            sb.append("!n");
        }
        sb.append("\t\t\t").append(name).append("\t\t\t").append(path).append('\n');
        return sb.toString();
    }

    private String getFileDateAttributes() throws IOException {
        Path path = Paths.get(file.getAbsolutePath());
        BasicFileAttributes atr = Files.readAttributes(path, BasicFileAttributes.class);
        final StringBuilder sb = new StringBuilder();
        sb.append("atr lastModifiedTime ").append(atr.lastModifiedTime().toMillis()).append("\t\t\t").append("atr lastAccessTime ").append(atr.lastAccessTime().toMillis()).append("\t\t\t").append("atr creationTime ").append(atr.creationTime().toMillis());
        return sb.toString();
    }

}
