package aljx.java.util.debug;

public class LoggerSet implements Logger.LogImplementation {

    private final Logger.LogImplementation[] loggers;

    public LoggerSet(Logger.LogImplementation... loggers) {
        this.loggers = loggers;
    }

    @Override
    public void v(String tag, String s) {
        for (Logger.LogImplementation logger : loggers) {
            logger.v(tag, s);
        }
    }

    @Override
    public void d(String tag, String s) {
        for (Logger.LogImplementation logger : loggers) {
            logger.d(tag, s);
        }
    }

    @Override
    public void i(String tag, String s) {
        for (Logger.LogImplementation logger : loggers) {
            logger.i(tag, s);
        }
    }

    @Override
    public void w(String tag, String s) {
        for (Logger.LogImplementation logger : loggers) {
            logger.w(tag, s);
        }
    }

    @Override
    public void w(String tag, String s, Throwable tr) {
        for (Logger.LogImplementation logger : loggers) {
            logger.w(tag, s, tr);
        }
    }

    @Override
    public void e(String tag, String s) {
        for (Logger.LogImplementation logger : loggers) {
            logger.e(tag, s);
        }
    }

    @Override
    public void e(String tag, String s, Throwable tr) {
        for (Logger.LogImplementation logger : loggers) {
            logger.e(tag, s, tr);
        }
    }
}
