package aljx.java.util.debug;

import aljx.java.util.reflection.ReflectionUtils;

/**
 * @author Alex Andriichenko
 */
public class Logger {
    public static final LogImplementation logger;

    public static void v(String tag, String s) {
        logger.v(tag, s);
    }

    public static void d(String tag, String s) {
        logger.d(tag, s);
    }

    public static void i(String tag, String s) {
        logger.i(tag, s);
    }

    public static void w(String tag, String s) {
        logger.w(tag, s);
    }

    public static void w(String tag, String s, Throwable tr) {
        logger.w(tag, s, tr);
    }

    public static void e(String tag, String s) {
        logger.e(tag, s);
    }

    public static void e(String tag, String s, Throwable tr) {
        logger.e(tag, s, tr);
    }

    public interface LogImplementation {

        void v(String tag, String s);

        void d(String tag, String s);

        void i(String tag, String s);

        void w(String tag, String s);

        void w(String tag, String s, Throwable tr);

        void e(String tag, String s);

        void e(String tag, String s, Throwable tr);
    }

    private static class DefaultLogger implements LogImplementation {

        @Override
        public void v(String tag, String s) {
            System.out.println("" + tag + ", " + s);
        }

        @Override
        public void d(String tag, String s) {
            System.out.println("" + tag + ", " + s);
        }

        @Override
        public void i(String tag, String s) {
            System.out.println("" + tag + ", " + s);
        }

        @Override
        public void w(String tag, String s) {
            System.out.println("" + tag + ", " + s);
        }

        @Override
        public void w(String tag, String s, Throwable tr) {
            System.out.println("" + tag + ", " + s + '\n' + Dumper.dump(tr));
        }

        @Override
        public void e(String tag, String s) {
            System.out.println("" + tag + ", " + s);
        }

        @Override
        public void e(String tag, String s, Throwable tr) {
            System.out.println("" + tag + ", " + s + '\n' + Dumper.dump(tr));
        }
    }

    static {
        LogImplementation logImplementation = null;

        try {
            logImplementation = ReflectionUtils.
                    getInstanceUnsafe("aljx.android.util.debug.AndroidLogger");
        } catch (Exception e) {

        }

        if (logImplementation == null) {
            logImplementation = new DefaultLogger();
            logImplementation.i("Tracer", "Default logger init");
        }

        if (logImplementation == null) {
            throw new IllegalStateException();
        }

        logger = logImplementation;
    }

}
