package aljx.java.util.debug;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import aljx.java.util.file.LogSaveHelper;

public class FileLogger implements Logger.LogImplementation {

    private ThreadLocal<SimpleDateFormat> df = new ThreadLocal<SimpleDateFormat>() {
        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
        }
    };

    public FileLogger(File dir) {
        this(dir, 8);
    }

    public FileLogger(File dir, long mbSize) {
        LogSaveHelper.setSettings(dir, "log.txt", "old_log.txt", LogSaveHelper.ONE_MB * mbSize);
    }

    public static void resetFile() {
        LogSaveHelper.getLogFileStream(true);
    }

    private void write(String s) {
        try {
            LogSaveHelper.write(s);
        } catch (IOException e) {

        }
    }

    @Override
    public void v(String tag, String s) {
        final String time = df.get().format(new Date(System.currentTimeMillis()));
        final long tid = Thread.currentThread().getId();
        write(String.format("%s    %d/ V %s, %s\n", time, tid, tag, s));
    }

    @Override
    public void d(String tag, String s) {
        final String time = df.get().format(new Date(System.currentTimeMillis()));
        final long tid = Thread.currentThread().getId();
        write(String.format("%s    %d/ D %s, %s\n", time, tid, tag, s));
    }

    @Override
    public void i(String tag, String s) {
        final String time = df.get().format(new Date(System.currentTimeMillis()));
        final long tid = Thread.currentThread().getId();
        write(String.format("%s    %d/ I %s, %s\n", time, tid, tag, s));
    }

    @Override
    public void w(String tag, String s) {
        final String time = df.get().format(new Date(System.currentTimeMillis()));
        final long tid = Thread.currentThread().getId();
        write(String.format("%s    %d/ W %s, %s\n", time, tid, tag, s));
    }

    @Override
    public void w(String tag, String s, Throwable tr) {
        final String time = df.get().format(new Date(System.currentTimeMillis()));
        final long tid = Thread.currentThread().getId();
        write(String.format("%s    %d/ W %s, %s \n%s\n", time, tid, tag, s, Dumper.dump(tr)));
    }

    @Override
    public void e(String tag, String s) {
        final String time = df.get().format(new Date(System.currentTimeMillis()));
        final long tid = Thread.currentThread().getId();
        write(String.format("%s    %d/ E %s, %s\n", time, tid, tag, s));
    }

    @Override
    public void e(String tag, String s, Throwable tr) {
        final String time = df.get().format(new Date(System.currentTimeMillis()));
        final long tid = Thread.currentThread().getId();
        write(String.format("%s    %d/ E %s, %s \n%s\n", time, tid, tag, s, Dumper.dump(tr)));
    }
}
