package aljx.java.util.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import aljx.java.util.reflection.ObjectDumper;
import aljx.java.util.reflection.ReflectionUtils;
import aljx.java.util.text.TextUtils;

public class Dumper {

    private static final List<DumpExtension> sExtensionList;

    static {
        ArrayList<DumpExtension> extensions = new ArrayList<DumpExtension>();

        try {
            DumpExtension dumpExtension = ReflectionUtils.
                    getInstanceUnsafe("aljx.android.util.debug.AndroidDumpExtension");

            if (dumpExtension != null) {
                extensions.add(dumpExtension);
            }
        } catch (Exception e) {

        }

        extensions.add(new DefaultDumpExtension());
        sExtensionList = Collections.unmodifiableList(extensions);
    }

    public static abstract class DumpExtension {

        protected final String dump(Object value, ArrayList dumpedObjects) {
            return Dumper.dump(value, dumpedObjects);
        }

        public abstract String dumpImpl(Object value, ArrayList dumpedObjects);

        public abstract boolean canDump(Object value);
    }

    public static String toString(Object obj, int maxLength) {
        return TextUtils.ellipsize(String.valueOf(obj), maxLength);
    }

    public static String dumpFields(Object obj) {
        return ObjectDumper.dumpFields(obj);
    }

    public static String dump(Object value) {
        return dump(value, new ArrayList());
    }

    public static String dump(Object value, ArrayList dumpedObjects) {
        if (value == null) {
            return "null";
        }

        for (Object dumpedItem : dumpedObjects) {
            if (dumpedItem == value) {
                return String.format("duplicate %s@%s", value.getClass().getName(), Integer.toHexString(value.hashCode()));
            }
        }

        if (value == dumpedObjects) {
            return String.format("duplicate %s@%s", value.getClass().getName(), Integer.toHexString(value.hashCode()));
        }

        dumpedObjects.add(value);

        String result = null;
        for (DumpExtension extension : sExtensionList) {
            if (extension.canDump(value)) {
                result = extension.dumpImpl(value, dumpedObjects);
                break;
            }
        }

        dumpedObjects.remove(value);

        return result != null ? result :/*obj.getClass().getName() + " " + */value.toString();
    }
}