package aljx.java.util.date;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Alex Andriichenko
 */
public class DateUtils {
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_FILENAME_DATE_FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_MILLISECOND = new ThreadLocal<SimpleDateFormat>();
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_MILLISECOND = new ThreadLocal<SimpleDateFormat>();
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT_YEAR_MONTH_DAY = new ThreadLocal<SimpleDateFormat>();

    static {
        SIMPLE_FILENAME_DATE_FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_MILLISECOND.set(new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS"));
        SIMPLE_DATE_FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_MILLISECOND.set(new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS"));
        SIMPLE_DATE_FORMAT_YEAR_MONTH_DAY.set(new SimpleDateFormat("yyyy.MM.dd"));
    }

    public static String gatFilenameDateTime() {
        Date date = new Date(System.currentTimeMillis());
        Format format = SIMPLE_FILENAME_DATE_FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_MILLISECOND.get();
        return format.format(date);
    }

    public static String gatDateTime() {
        Date date = new Date(System.currentTimeMillis());
        Format format = SIMPLE_DATE_FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_MILLISECOND.get();
        return format.format(date);
    }

    public static String gatDateTime(long time) {
        Date date = new Date(time);
        Format format = SIMPLE_DATE_FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_MILLISECOND.get();
        return format.format(date);
    }

    public static String gatDate(long time) {
        Date date = new Date(time);
        Format format = SIMPLE_DATE_FORMAT_YEAR_MONTH_DAY.get();
        return format.format(date);
    }
}
