/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.sql;

import ai.grakn.migration.base.MigrationCLI;
import ai.grakn.migration.base.MigrationOptions;
import ai.grakn.migration.sql.SQLMigrationOptions;
import com.google.common.collect.Maps;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.impl.DSL;

public class SQLMigrator {
    private final Stream<Record> records;

    public static void main(String[] args) {
        try {
            MigrationCLI.init((String[])args, SQLMigrationOptions::new).stream().filter(Optional::isPresent).map(Optional::get).forEach(SQLMigrator::runSQL);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
    }

    private static void runSQL(SQLMigrationOptions options) {
        try {
            File sqlTemplate = new File(options.getTemplate());
            if (!sqlTemplate.exists()) {
                System.err.println("Cannot find file: " + options.getTemplate());
                return;
            }
            if (options.hasDriver()) {
                DriverManager.registerDriver(options.getDriver());
            }
            try (Connection connection = DriverManager.getConnection(options.getLocation(), options.getUsername(), options.getPassword());){
                SQLMigrator sqlMigrator = new SQLMigrator(options.getQuery(), connection);
                MigrationCLI.loadOrPrint((File)sqlTemplate, sqlMigrator.convert(), (MigrationOptions)options);
            }
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
        }
    }

    public SQLMigrator(String query, Connection connection) {
        DSLContext create = DSL.using((Connection)connection);
        this.records = create.fetchStream(query);
    }

    public Stream<Map<String, Object>> convert() {
        return this.records.map(Record::intoMap).map(this::convertToValidValues);
    }

    private Map<String, Object> convertToValidValues(Map<String, Object> data) {
        data = Maps.filterValues(data, Objects::nonNull);
        data = Maps.transformValues((Map)data, this::convertToSupportedTypes);
        return data;
    }

    private Object convertToSupportedTypes(Object object) {
        if (!(object instanceof String || object instanceof Number || object instanceof List || object instanceof Boolean)) {
            return object.toString();
        }
        return object;
    }
}

