/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.sql;

import ai.grakn.migration.base.MigrationOptions;
import java.sql.Driver;

public class SQLMigrationOptions
extends MigrationOptions {
    public SQLMigrationOptions(String[] args) {
        this.options.addOption("driver", true, "JDBC driver");
        this.options.addOption("location", true, "JDBC url (location of DB)");
        this.options.addOption("user", true, "JDBC username");
        this.options.addOption("pass", true, "JDBC password");
        this.options.addOption("q", "query", true, "SQL Query");
        this.options.addOption("t", "template", true, "Graql template to apply to the data.");
        this.parse(args);
    }

    public Driver getDriver() {
        if (this.command.hasOption("driver")) {
            try {
                return (Driver)Class.forName(this.command.getOptionValue("driver")).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        throw new IllegalArgumentException("No driver specified (-driver)");
    }

    public boolean hasDriver() {
        return this.command.hasOption("driver");
    }

    public String getLocation() {
        if (this.command.hasOption("location")) {
            return this.command.getOptionValue("location");
        }
        throw new IllegalArgumentException("No db specified (-location)");
    }

    public String getUsername() {
        if (this.command.hasOption("user")) {
            return this.command.getOptionValue("user");
        }
        throw new IllegalArgumentException("No username specified (-user)");
    }

    public String getPassword() {
        if (this.command.hasOption("pass")) {
            return this.command.getOptionValue("pass");
        }
        throw new IllegalArgumentException("No password specified (-pass)");
    }

    public String getQuery() {
        if (this.command.hasOption("query")) {
            return this.command.getOptionValue("query");
        }
        throw new IllegalArgumentException("No SQL query specified (-query)");
    }
}

