/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.client.rpc;

import ai.grakn.GraknTxType;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.rpc.proto.ConceptProto;
import ai.grakn.rpc.proto.KeyspaceProto;
import ai.grakn.rpc.proto.SessionProto;
import ai.grakn.util.CommonUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.stream.Collectors;

public class RequestBuilder {

    public static class Keyspace {
        public static KeyspaceProto.Keyspace.Delete.Req delete(String name) {
            return KeyspaceProto.Keyspace.Delete.Req.newBuilder().setName(name).build();
        }
    }

    public static class Concept {
        public static ConceptProto.Concept concept(ai.grakn.concept.Concept concept) {
            return ConceptProto.Concept.newBuilder().setId(concept.id().getValue()).setBaseType(Concept.getBaseType(concept)).build();
        }

        private static ConceptProto.Concept.BASE_TYPE getBaseType(ai.grakn.concept.Concept concept) {
            if (concept.isEntityType()) {
                return ConceptProto.Concept.BASE_TYPE.ENTITY_TYPE;
            }
            if (concept.isRelationshipType()) {
                return ConceptProto.Concept.BASE_TYPE.RELATION_TYPE;
            }
            if (concept.isAttributeType()) {
                return ConceptProto.Concept.BASE_TYPE.ATTRIBUTE_TYPE;
            }
            if (concept.isEntity()) {
                return ConceptProto.Concept.BASE_TYPE.ENTITY;
            }
            if (concept.isRelationship()) {
                return ConceptProto.Concept.BASE_TYPE.RELATION;
            }
            if (concept.isAttribute()) {
                return ConceptProto.Concept.BASE_TYPE.ATTRIBUTE;
            }
            if (concept.isRole()) {
                return ConceptProto.Concept.BASE_TYPE.ROLE;
            }
            if (concept.isRule()) {
                return ConceptProto.Concept.BASE_TYPE.RULE;
            }
            if (concept.isType()) {
                return ConceptProto.Concept.BASE_TYPE.META_TYPE;
            }
            throw CommonUtil.unreachableStatement((String)("Unrecognised concept " + concept));
        }

        public static Collection<ConceptProto.Concept> concepts(Collection<ai.grakn.concept.Concept> concepts) {
            return concepts.stream().map(Concept::concept).collect(Collectors.toList());
        }

        public static ConceptProto.ValueObject attributeValue(Object value) {
            ConceptProto.ValueObject.Builder builder = ConceptProto.ValueObject.newBuilder();
            if (value instanceof String) {
                builder.setString((String)value);
            } else if (value instanceof Boolean) {
                builder.setBoolean((Boolean)value);
            } else if (value instanceof Integer) {
                builder.setInteger((Integer)value);
            } else if (value instanceof Long) {
                builder.setLong((Long)value);
            } else if (value instanceof Float) {
                builder.setFloat(((Float)value).floatValue());
            } else if (value instanceof Double) {
                builder.setDouble((Double)value);
            } else if (value instanceof LocalDateTime) {
                builder.setDate(((LocalDateTime)value).atZone(ZoneId.of("Z")).toInstant().toEpochMilli());
            } else {
                throw CommonUtil.unreachableStatement((String)("Unrecognised " + value));
            }
            return builder.build();
        }

        public static AttributeType.DataType<?> dataType(ConceptProto.AttributeType.DATA_TYPE dataType) {
            switch (dataType) {
                case STRING: {
                    return AttributeType.DataType.STRING;
                }
                case BOOLEAN: {
                    return AttributeType.DataType.BOOLEAN;
                }
                case INTEGER: {
                    return AttributeType.DataType.INTEGER;
                }
                case LONG: {
                    return AttributeType.DataType.LONG;
                }
                case FLOAT: {
                    return AttributeType.DataType.FLOAT;
                }
                case DOUBLE: {
                    return AttributeType.DataType.DOUBLE;
                }
                case DATE: {
                    return AttributeType.DataType.DATE;
                }
            }
            throw new IllegalArgumentException("Unrecognised " + (Object)((Object)dataType));
        }

        static ConceptProto.AttributeType.DATA_TYPE dataType(AttributeType.DataType<?> dataType) {
            if (dataType.equals((Object)AttributeType.DataType.STRING)) {
                return ConceptProto.AttributeType.DATA_TYPE.STRING;
            }
            if (dataType.equals((Object)AttributeType.DataType.BOOLEAN)) {
                return ConceptProto.AttributeType.DATA_TYPE.BOOLEAN;
            }
            if (dataType.equals((Object)AttributeType.DataType.INTEGER)) {
                return ConceptProto.AttributeType.DATA_TYPE.INTEGER;
            }
            if (dataType.equals((Object)AttributeType.DataType.LONG)) {
                return ConceptProto.AttributeType.DATA_TYPE.LONG;
            }
            if (dataType.equals((Object)AttributeType.DataType.FLOAT)) {
                return ConceptProto.AttributeType.DATA_TYPE.FLOAT;
            }
            if (dataType.equals((Object)AttributeType.DataType.DOUBLE)) {
                return ConceptProto.AttributeType.DATA_TYPE.DOUBLE;
            }
            if (dataType.equals((Object)AttributeType.DataType.DATE)) {
                return ConceptProto.AttributeType.DATA_TYPE.DATE;
            }
            throw CommonUtil.unreachableStatement((String)("Unrecognised " + dataType));
        }
    }

    public static class Transaction {
        public static SessionProto.Transaction.Req open(ai.grakn.Keyspace keyspace, GraknTxType txType) {
            SessionProto.Transaction.Open.Req openRequest = SessionProto.Transaction.Open.Req.newBuilder().setKeyspace(keyspace.getValue()).setType(SessionProto.Transaction.Type.valueOf(txType.getId())).build();
            return SessionProto.Transaction.Req.newBuilder().setOpenReq(openRequest).build();
        }

        public static SessionProto.Transaction.Req commit() {
            return SessionProto.Transaction.Req.newBuilder().setCommitReq(SessionProto.Transaction.Commit.Req.getDefaultInstance()).build();
        }

        public static SessionProto.Transaction.Req query(Query<?> query) {
            return Transaction.query(query.toString(), query.inferring());
        }

        public static SessionProto.Transaction.Req query(String queryString) {
            return Transaction.query(queryString, true);
        }

        public static SessionProto.Transaction.Req query(String queryString, boolean infer) {
            SessionProto.Transaction.Query.Req request = SessionProto.Transaction.Query.Req.newBuilder().setQuery(queryString).setInfer(infer ? SessionProto.Transaction.Query.INFER.TRUE : SessionProto.Transaction.Query.INFER.FALSE).build();
            return SessionProto.Transaction.Req.newBuilder().setQueryReq(request).build();
        }

        public static SessionProto.Transaction.Req getSchemaConcept(Label label) {
            return SessionProto.Transaction.Req.newBuilder().setGetSchemaConceptReq(SessionProto.Transaction.GetSchemaConcept.Req.newBuilder().setLabel(label.getValue())).build();
        }

        public static SessionProto.Transaction.Req getConcept(ConceptId id) {
            return SessionProto.Transaction.Req.newBuilder().setGetConceptReq(SessionProto.Transaction.GetConcept.Req.newBuilder().setId(id.getValue())).build();
        }

        public static SessionProto.Transaction.Req getAttributes(Object value) {
            return SessionProto.Transaction.Req.newBuilder().setGetAttributesReq(SessionProto.Transaction.GetAttributes.Req.newBuilder().setValue(Concept.attributeValue(value))).build();
        }

        public static SessionProto.Transaction.Req putEntityType(Label label) {
            return SessionProto.Transaction.Req.newBuilder().setPutEntityTypeReq(SessionProto.Transaction.PutEntityType.Req.newBuilder().setLabel(label.getValue())).build();
        }

        public static SessionProto.Transaction.Req putAttributeType(Label label, AttributeType.DataType<?> dataType) {
            SessionProto.Transaction.PutAttributeType.Req request = SessionProto.Transaction.PutAttributeType.Req.newBuilder().setLabel(label.getValue()).setDataType(Concept.dataType(dataType)).build();
            return SessionProto.Transaction.Req.newBuilder().setPutAttributeTypeReq(request).build();
        }

        public static SessionProto.Transaction.Req putRelationshipType(Label label) {
            SessionProto.Transaction.PutRelationType.Req request = SessionProto.Transaction.PutRelationType.Req.newBuilder().setLabel(label.getValue()).build();
            return SessionProto.Transaction.Req.newBuilder().setPutRelationTypeReq(request).build();
        }

        public static SessionProto.Transaction.Req putRole(Label label) {
            SessionProto.Transaction.PutRole.Req request = SessionProto.Transaction.PutRole.Req.newBuilder().setLabel(label.getValue()).build();
            return SessionProto.Transaction.Req.newBuilder().setPutRoleReq(request).build();
        }

        public static SessionProto.Transaction.Req putRule(Label label, Pattern when, Pattern then) {
            SessionProto.Transaction.PutRule.Req request = SessionProto.Transaction.PutRule.Req.newBuilder().setLabel(label.getValue()).setWhen(when.toString()).setThen(then.toString()).build();
            return SessionProto.Transaction.Req.newBuilder().setPutRuleReq(request).build();
        }

        public static SessionProto.Transaction.Req iterate(int iteratorId) {
            return SessionProto.Transaction.Req.newBuilder().setIterateReq(SessionProto.Transaction.Iter.Req.newBuilder().setId(iteratorId)).build();
        }
    }
}

