/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.model;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.v2.model.LanguageInfo;
import java.util.List;

public class TaxonomyInfo {
    private String name;
    private String contract;
    private String description;
    private List<LanguageInfo> languages;

    public LanguageInfo getLanguagesByName(String name) throws NLApiException {
        return this.languages.stream().filter(language -> language.getName().equals(name)).findAny().orElseThrow(() -> new NLApiException(NLApiErrorCode.REQUEST_UNKNOWN_LANGUAGE_ERROR));
    }

    public String getName() {
        return this.name;
    }

    public String getContract() {
        return this.contract;
    }

    public String getDescription() {
        return this.description;
    }

    public List<LanguageInfo> getLanguages() {
        return this.languages;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLanguages(List<LanguageInfo> languages) {
        this.languages = languages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaxonomyInfo)) {
            return false;
        }
        TaxonomyInfo other = (TaxonomyInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$contract = this.getContract();
        String other$contract = other.getContract();
        if (this$contract == null ? other$contract != null : !this$contract.equals(other$contract)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<LanguageInfo> this$languages = this.getLanguages();
        List<LanguageInfo> other$languages = other.getLanguages();
        return !(this$languages == null ? other$languages != null : !((Object)this$languages).equals(other$languages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaxonomyInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $contract = this.getContract();
        result = result * 59 + ($contract == null ? 43 : $contract.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<LanguageInfo> $languages = this.getLanguages();
        result = result * 59 + ($languages == null ? 43 : ((Object)$languages).hashCode());
        return result;
    }

    public String toString() {
        return "TaxonomyInfo(name=" + this.getName() + ", contract=" + this.getContract() + ", description=" + this.getDescription() + ", languages=" + this.getLanguages() + ")";
    }

    public TaxonomyInfo(String name, String contract, String description, List<LanguageInfo> languages) {
        this.name = name;
        this.contract = contract;
        this.description = description;
        this.languages = languages;
    }

    public TaxonomyInfo() {
    }
}

