/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.message;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.v2.model.TaxonomyInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;

public class TaxonomiesResponse {
    private List<TaxonomyInfo> taxonomies;

    public TaxonomyInfo getTaxonomyByName(String name) throws NLApiException {
        return this.taxonomies.stream().filter(taxonomy -> taxonomy.getName().equals(name)).findAny().orElseThrow(() -> new NLApiException(NLApiErrorCode.REQUEST_UNKNOWN_TAXONOMY_ERROR));
    }

    public String toJSON() {
        ObjectMapper om = new ObjectMapper();
        return om.writeValueAsString((Object)this);
    }

    public void prettyPrint() {
        System.out.println(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this));
    }

    public List<TaxonomyInfo> getTaxonomies() {
        return this.taxonomies;
    }

    public void setTaxonomies(List<TaxonomyInfo> taxonomies) {
        this.taxonomies = taxonomies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaxonomiesResponse)) {
            return false;
        }
        TaxonomiesResponse other = (TaxonomiesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<TaxonomyInfo> this$taxonomies = this.getTaxonomies();
        List<TaxonomyInfo> other$taxonomies = other.getTaxonomies();
        return !(this$taxonomies == null ? other$taxonomies != null : !((Object)this$taxonomies).equals(other$taxonomies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaxonomiesResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TaxonomyInfo> $taxonomies = this.getTaxonomies();
        result = result * 59 + ($taxonomies == null ? 43 : ((Object)$taxonomies).hashCode());
        return result;
    }

    public String toString() {
        return "TaxonomiesResponse(taxonomies=" + this.getTaxonomies() + ")";
    }

    public TaxonomiesResponse(List<TaxonomyInfo> taxonomies) {
        this.taxonomies = taxonomies;
    }

    public TaxonomiesResponse() {
    }
}

