/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.message;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.v2.model.ContextInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;

public class DetectorsResponse {
    private List<ContextInfo> detectors;

    public ContextInfo getDetectorByName(String name) throws NLApiException {
        return this.detectors.stream().filter(context -> context.getName().equals(name)).findAny().orElseThrow(() -> new NLApiException(NLApiErrorCode.REQUEST_UNKNOWN_CONTEXT_ERROR));
    }

    public String toJSON() {
        ObjectMapper om = new ObjectMapper();
        return om.writeValueAsString((Object)this);
    }

    public void prettyPrint() {
        System.out.println(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this));
    }

    public List<ContextInfo> getDetectors() {
        return this.detectors;
    }

    public void setDetectors(List<ContextInfo> detectors) {
        this.detectors = detectors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetectorsResponse)) {
            return false;
        }
        DetectorsResponse other = (DetectorsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ContextInfo> this$detectors = this.getDetectors();
        List<ContextInfo> other$detectors = other.getDetectors();
        return !(this$detectors == null ? other$detectors != null : !((Object)this$detectors).equals(other$detectors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DetectorsResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ContextInfo> $detectors = this.getDetectors();
        result = result * 59 + ($detectors == null ? 43 : ((Object)$detectors).hashCode());
        return result;
    }

    public String toString() {
        return "DetectorsResponse(detectors=" + this.getDetectors() + ")";
    }

    public DetectorsResponse(List<ContextInfo> detectors) {
        this.detectors = detectors;
    }

    public DetectorsResponse() {
    }
}

