/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.message;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.v2.model.ContextInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;

public class ContextsResponse {
    private List<ContextInfo> contexts;

    public ContextInfo getContextByName(String name) throws NLApiException {
        return this.contexts.stream().filter(context -> context.getName().equals(name)).findAny().orElseThrow(() -> new NLApiException(NLApiErrorCode.REQUEST_UNKNOWN_CONTEXT_ERROR));
    }

    public String toJSON() {
        ObjectMapper om = new ObjectMapper();
        return om.writeValueAsString((Object)this);
    }

    public void prettyPrint() {
        System.out.println(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this));
    }

    public List<ContextInfo> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<ContextInfo> contexts) {
        this.contexts = contexts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextsResponse)) {
            return false;
        }
        ContextsResponse other = (ContextsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ContextInfo> this$contexts = this.getContexts();
        List<ContextInfo> other$contexts = other.getContexts();
        return !(this$contexts == null ? other$contexts != null : !((Object)this$contexts).equals(other$contexts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContextsResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ContextInfo> $contexts = this.getContexts();
        result = result * 59 + ($contexts == null ? 43 : ((Object)$contexts).hashCode());
        return result;
    }

    public String toString() {
        return "ContextsResponse(contexts=" + this.getContexts() + ")";
    }

    public ContextsResponse(List<ContextInfo> contexts) {
        this.contexts = contexts;
    }

    public ContextsResponse() {
    }
}

