/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.cloud;

import ai.expert.nlapi.security.Authentication;
import ai.expert.nlapi.v2.API;

public final class DetectorConfig {
    private final API.Versions version;
    private final String detector;
    private final API.Languages language;
    private final Authentication authentication;

    DetectorConfig(API.Versions version, String detector, API.Languages language, Authentication authentication) {
        this.version = version;
        this.detector = detector;
        this.language = language;
        this.authentication = authentication;
    }

    public static DetectorConfigBuilder builder() {
        return new DetectorConfigBuilder();
    }

    public API.Versions getVersion() {
        return this.version;
    }

    public String getDetector() {
        return this.detector;
    }

    public API.Languages getLanguage() {
        return this.language;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetectorConfig)) {
            return false;
        }
        DetectorConfig other = (DetectorConfig)o;
        API.Versions this$version = this.getVersion();
        API.Versions other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version)) {
            return false;
        }
        String this$detector = this.getDetector();
        String other$detector = other.getDetector();
        if (this$detector == null ? other$detector != null : !this$detector.equals(other$detector)) {
            return false;
        }
        API.Languages this$language = this.getLanguage();
        API.Languages other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language)) {
            return false;
        }
        Authentication this$authentication = this.getAuthentication();
        Authentication other$authentication = other.getAuthentication();
        return !(this$authentication == null ? other$authentication != null : !this$authentication.equals(other$authentication));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        API.Versions $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
        String $detector = this.getDetector();
        result = result * 59 + ($detector == null ? 43 : $detector.hashCode());
        API.Languages $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : ((Object)((Object)$language)).hashCode());
        Authentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : $authentication.hashCode());
        return result;
    }

    public String toString() {
        return "DetectorConfig(version=" + (Object)((Object)this.getVersion()) + ", detector=" + this.getDetector() + ", language=" + (Object)((Object)this.getLanguage()) + ", authentication=" + this.getAuthentication() + ")";
    }

    public static class DetectorConfigBuilder {
        private API.Versions version;
        private String detector;
        private API.Languages language;
        private Authentication authentication;

        DetectorConfigBuilder() {
        }

        public DetectorConfigBuilder withVersion(API.Versions version) {
            this.version = version;
            return this;
        }

        public DetectorConfigBuilder withDetector(String detector) {
            this.detector = detector;
            return this;
        }

        public DetectorConfigBuilder withLanguage(API.Languages language) {
            this.language = language;
            return this;
        }

        public DetectorConfigBuilder withAuthentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public DetectorConfig build() {
            return new DetectorConfig(this.version, this.detector, this.language, this.authentication);
        }

        public String toString() {
            return "DetectorConfig.DetectorConfigBuilder(version=" + (Object)((Object)this.version) + ", detector=" + this.detector + ", language=" + (Object)((Object)this.language) + ", authentication=" + this.authentication + ")";
        }
    }
}

