/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.exceptions;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum NLApiErrorCode {
    DATA_PROCESSING_ERROR(100, "Data Processing Error"),
    DATA_EMPTY_ERROR(100, "Data empty Error"),
    AUTHENTICATION_ERROR(300, "Authentication Error"),
    CONNECTION_ERROR(400, "Connection Error"),
    EXECUTION_REQUEST_ERROR(401, "Excecution Request Error"),
    AUTHORIZATION_ERROR(401, "Unauthorized Error, please check credetial or authorizion token."),
    REQUEST_UNKNOWN_LANGUAGE_ERROR(501, "Unknown Language"),
    REQUEST_UNKNOWN_CONTEXT_ERROR(502, "Unknown Context"),
    REQUEST_UNKNOWN_TAXONOMY_ERROR(502, "Unknown Taxonomy"),
    PARSING_ERROR(600, "Parsing Error");

    public static final String BUNDLE_NAME;
    private final int errorCode;
    private final String errorMessage;

    private NLApiErrorCode(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage != null ? errorMessage : "";
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getBusinessMessage(ResourceBundle bundle) {
        try {
            return bundle.getString(this.errorCode + ": " + this.errorMessage);
        }
        catch (MissingResourceException e) {
            return "NLapi Error (" + this.errorCode + ": " + this.errorMessage + ")";
        }
    }

    static {
        BUNDLE_NAME = NLApiErrorCode.class.getName();
    }
}

